	% Spectrum of the up-sampled signal 
	clear all, close all 
	F = [0,0.2,0.8,1]; A = [0,1,0,0]; x = fir2(128, F, A); 	% Original signal
	wT = linspace(0, pi, 512);
	for L = 1:4
		xup = UP_SAMPLE(x, L);
		Xup = fft(xup,1024); % Computing the spectrum of the up-sampled signal 
		subplot(4,1,L),	PLOT_ABS_Z(wT, abs(Xup(1:512)),strcat('X_', int2str(L)))
		text(0.9,0.5,strcat({'L = '},int2str(L)))
	end
	xlabel('{\it\omegaT} [rad]');		
	
